import pandas as pd   
import pickle
   
# Load the dataset   
credit_customers = pd.read_csv("credit_customers.csv")   
  
middle_aged_customers = credit_customers[(credit_customers['age'] > 40) & (credit_customers['age'] < 59)]   

stable_employment_customers = credit_customers[credit_customers['employment'].isin(['>=7', '4<=X<7'])]   

good_credit_history_customers = credit_customers[credit_customers['credit_history'].isin(['existing paid', 'no credits/all paid', 'all paid'])] 

print(middle_aged_customers)
pickle.dump(middle_aged_customers,open("./ref_result/middle_aged_customers.pkl","wb"))

print(stable_employment_customers)
pickle.dump(stable_employment_customers,open("./ref_result/stable_employment_customers.pkl","wb"))

print(good_credit_history_customers)
pickle.dump(good_credit_history_customers,open("./ref_result/good_credit_history_customers.pkl","wb"))

  